import * as React from "react";

import * as QueryString from "query-string";

import { Button, ButtonType, Display, FlexDirection, JustifyContent, Layout, SVGAsset } from "twitch-core-ui";

import { DetailedUser } from "aegis/models";

export interface PublicProps {
  user: DetailedUser;
}

export class AccountInfoHeaderActions extends React.Component<PublicProps> {
  public render() {
    const altLookupUrl = "/altlookup?" + QueryString.stringify({ id: this.props.user.id });
    return (
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        justifyContent={JustifyContent.Between}
        padding={{ y: 1 }}
      >
        <Layout>
          <Button
            type={ButtonType.Hollow}
            icon={SVGAsset.NavSearch}
            linkTo={altLookupUrl}
            targetBlank
            data-track-click="account-info-header-alt-lookup"
          >
            Alt account lookup
          </Button>
        </Layout>
      </Layout>
    );
  }
}
