import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockDetailedUser } from "aegis/models/mocks";
import { AccountInfoHeaderDetails, PublicProps, TestSelectors } from "./component";

import "aegis/functionality/date-extensions.ts";

Enzyme.configure({ adapter: new Adapter() });

describe("account info header details", () => {
  const setupShallow = (override?: Partial<PublicProps>) => {
    const props: PublicProps = {
      user: MockDetailedUser(),
      ...override
    };
    return Enzyme.shallow(<AccountInfoHeaderDetails {...props} />);
  };

  it("renders with login and display name visible", () => {
    const wrapper = setupShallow();

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.Login })
        .children()
        .text()
    ).toBe(MockDetailedUser().login);

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.DisplayName })
        .children()
        .text()
    ).toBe(MockDetailedUser().displayName);
  });
});
