import * as React from "react";

import { AlignItems, Color, CoreText, Display, Layout, TextType } from "twitch-core-ui";

import { DetailedUser } from "aegis/models";

export interface PublicProps {
  user: DetailedUser;
}
export enum TestSelectors {
  Login = "account-info-details-login",
  DisplayName = "account-info-details-display-name"
}

export class AccountInfoHeaderDetails extends React.Component<PublicProps> {
  public render() {
    const { user } = this.props;
    return (
      <Layout flexGrow={1} display={Display.Flex} alignItems={AlignItems.Center}>
        <Layout padding={{ left: 2, y: 1 }} flexGrow={1}>
          <CoreText color={Color.Alt2} type={TextType.H5}>
            Login
          </CoreText>
          <CoreText type={TextType.H4} bold data-test-selector={TestSelectors.Login}>
            {user.login}
          </CoreText>
        </Layout>
        <Layout padding={{ left: 2, y: 1 }} flexGrow={1}>
          <CoreText color={Color.Alt2} type={TextType.H5}>
            Display Name
          </CoreText>
          <CoreText type={TextType.H4} bold data-test-selector={TestSelectors.DisplayName}>
            {user.displayName}
          </CoreText>
        </Layout>
        <Layout padding={{ left: 2, y: 1 }} flexGrow={1}>
          <CoreText color={Color.Alt2} type={TextType.H5}>
            User ID
          </CoreText>
          <CoreText type={TextType.H4} bold>
            {user.id}
          </CoreText>
        </Layout>
        <Layout padding={{ left: 2, y: 1 }} flexGrow={1}>
          <CoreText color={Color.Alt2} type={TextType.H5}>
            Created
          </CoreText>
          <CoreText type={TextType.H4} bold>
            {user.createdAt ? new Date(user.createdAt).toDisplayFormat() : null}
          </CoreText>
        </Layout>
      </Layout>
    );
  }
}
