import * as React from "react";

import { BorderRadius, Display, StyledLayout } from "twitch-core-ui";

import { DetailedUser } from "aegis/models";
import { AccountInfoHeaderActions } from "./account-actions";
import { AccountInfoHeaderBanner } from "./account-banner";
import { AccountInfoHeaderDetails } from "./account-details";

export interface PublicProps {
  user: DetailedUser;
}

export class AccountInfoHeader extends React.Component<PublicProps> {
  public render() {
    const { user } = this.props;
    return (
      <>
        <StyledLayout border display={Display.Flex} borderRadius={BorderRadius.Large}>
          <AccountInfoHeaderBanner user={user} />
          <AccountInfoHeaderDetails user={user} />
        </StyledLayout>
        <AccountInfoHeaderActions user={user} />
      </>
    );
  }
}
