import * as React from "react";

import * as QueryString from "query-string";
import { RouteComponentProps, withRouter } from "react-router";

import { AlignItems, CoreText, Display, Layout, TextType } from "twitch-core-ui";

import { UserInput } from "aegis/functionality/components/user-input";
import { User } from "aegis/models";
import { QueryProps } from "aegis/pages/account-info";

export interface PublicProps {
  defaultID?: string;
}
type RouteProps = RouteComponentProps<{}>;

type Props = PublicProps & RouteProps;

export class AccountInfoSearchComponent extends React.Component<Props> {
  public render() {
    const { defaultID } = this.props;
    return (
      <Layout padding={{ bottom: 1 }}>
        <Layout padding={{ bottom: 0.5 }} display={Display.Flex} alignItems={AlignItems.Center}>
          <CoreText type={TextType.H4} bold lines={1}>
            Account Overview
          </CoreText>
        </Layout>
        <UserInput name="account-info-user" defaultID={defaultID} onChange={this.changeUser} hideUser />
      </Layout>
    );
  }

  private changeUser = (user?: User) => {
    if (!user || (this.props.defaultID && user.id === this.props.defaultID)) {
      return;
    }
    const queryParams = QueryString.parse(location.search) as QueryProps;
    const updatedParams = QueryString.stringify({ ...queryParams, id: user.id });
    this.props.history.push({ pathname: "/accountinfo", search: updatedParams });
  };
}

export const AccountInfoSearch: React.ComponentClass<PublicProps> = withRouter<Props>(AccountInfoSearchComponent);
