import * as React from "react";

import { Color, CoreText, Layout } from "twitch-core-ui";

import { AdminActionType } from "aegis/models";
import { ContentAudit } from "../container";

export const AdminAction: React.SFC<{ adminAction: ContentAudit }> = ({ adminAction }) => {
  if (adminAction.action === AdminActionType.Delete) {
    return (
      <Layout padding={{ y: 0.5 }}>
        <CoreText>
          {adminAction.actionBy.ldap} deleted {adminAction.resourceType} with id {adminAction.resourceID}
        </CoreText>
        <CoreText color={Color.Alt2}>{new Date(adminAction.createdAt).toDisplayFormat()}</CoreText>
      </Layout>
    );
  }
  return <Layout>{adminAction.actionBy.ldap} performed an unknown action</Layout>;
};
