import * as React from "react";

import {
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  LoadingSpinner,
  Pagination,
  PaginationMouseEvent
} from "twitch-core-ui";

import { AdminAction } from "../admin-action";
import { CONTENT_AUDIT_LIMIT, ContentAudit } from "./container";

import "./styles.scss";

export interface Props {
  adminActions: ContentAudit[];
  getAuditsForPage: (pageNumber: number) => void;
  total: number;
  offset: number;
  loading?: boolean;
}

export const AdminActionsModalComponent: React.SFC<Props> = props => {
  const { adminActions } = props;
  const currentPage = props.offset / CONTENT_AUDIT_LIMIT + 1;
  const totalPages = Math.ceil(props.total / CONTENT_AUDIT_LIMIT);

  const actions = props.loading ? (
    <LoadingSpinner />
  ) : (
    adminActions.map((action, index) => {
      return <AdminAction adminAction={action} key={index} />;
    })
  );

  return (
    <Layout display={Display.Flex} flexDirection={FlexDirection.Column} padding={2}>
      <Layout display={Display.Flex} flexDirection={FlexDirection.Column} className={"admin-actions-modal-body"}>
        {actions}
      </Layout>
      <Layout fullWidth display={Display.Flex} justifyContent={JustifyContent.Center}>
        <Pagination
          currentPage={currentPage}
          totalPages={totalPages}
          onClickIndex={(e: PaginationMouseEvent<HTMLDivElement>): void => {
            props.getAuditsForPage(e.goToPage);
          }}
          onClickNext={() => props.getAuditsForPage(currentPage + 1)}
          onClickPrevious={() => props.getAuditsForPage(currentPage - 1)}
          nextPageButtonAriaLabel="Next Page"
          previousPageButtonAriaLabel="Previous Page"
        />
      </Layout>
    </Layout>
  );
};
