import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockAdmin, MockDetailedUser } from "aegis/models/mocks";
import { AdminAction } from "./admin-action";
import { AdminActionsComponent } from "./component";
import { ContentAudit } from "./container";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

describe("AdminActions", () => {
  it("renders empty state", () => {
    const wrapper = Enzyme.mount(
      <AdminActionsComponent user={MockDetailedUser()} adminActions={[]} showMore={false} />
    );

    expect(wrapper.text()).toBe("None");
  });

  it("renders some actions", () => {
    const adminActions: ContentAudit[] = [
      {
        id: "actionID",
        action: "delete",
        actionBy: MockAdmin(),
        resourceID: "resourceID",
        resourceType: "clip",
        createdAt: new Date().toString()
      }
    ];
    const wrapper = Enzyme.mount(
      <AdminActionsComponent user={MockDetailedUser()} adminActions={adminActions} showMore={false} />
    );

    expect(wrapper.find(AdminAction)).toHaveLength(adminActions.length);
  });
});
