import * as React from "react";

import { Button, CoreText, Display, FlexDirection, Layout } from "twitch-core-ui";

import { DetailedUser } from "aegis/models";

import { AdminAction } from "./admin-action";
import { AdminActionsModal } from "./admin-actions-modal";
import { ContentAudit } from "./container";

export interface Props {
  user: DetailedUser;
  adminActions: ContentAudit[];
  showMore: boolean;
}

export const AdminActionsComponent: React.SFC<Props> = ({ adminActions, showMore, user }) => {
  if (adminActions.length === 0) {
    return <CoreText>None</CoreText>;
  }

  const actions = adminActions.map((action, index) => {
    return <AdminAction adminAction={action} key={index} />;
  });

  const [showMoreModal, setShowMoreModal] = React.useState(false);

  return (
    <Layout display={Display.Flex} flexDirection={FlexDirection.Column}>
      {actions}
      {showMore && <Button onClick={() => setShowMoreModal(true)}>Show More</Button>}
      {showMoreModal && <AdminActionsModal user={user} closeModal={() => setShowMoreModal(false)} />}
    </Layout>
  );
};
