import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { PartnerEscalationComponent, Props, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("account info partner escalation", () => {
  const setupShallow = (override?: Partial<Props>) => {
    const props: Props = {
      loading: false,
      onClick: jest.fn(),
      ...override
    };
    return Enzyme.shallow(<PartnerEscalationComponent {...props} />);
  };

  it("renders with login and display name visible", () => {
    const fn = jest.fn();
    const wrapper = setupShallow({ onClick: fn });

    const button = wrapper.find({ "data-test-selector": TestSelectors.RemoveButton });

    expect(button).toHaveLength(1);

    button.simulate("click");

    expect(fn).toHaveBeenCalled();
  });
});
