import * as React from "react";

import {
  AlignItems,
  Button,
  ButtonSize,
  ButtonType,
  CoreText,
  Display,
  JustifyContent,
  Layout,
  SVGAsset
} from "twitch-core-ui";

export interface Props {
  loading: boolean;
  onClick: () => void;
}

export enum TestSelectors {
  RemoveButton = "account-info--partner-escalation-remove-button"
}

export const PartnerEscalationComponent: React.SFC<Props> = ({ loading, onClick }) => {
  return (
    <Layout fullWidth display={Display.Flex} justifyContent={JustifyContent.Between} alignItems={AlignItems.Center}>
      <CoreText>Escalated Partner</CoreText>
      <Button
        data-test-selector={TestSelectors.RemoveButton}
        size={ButtonSize.Small}
        disabled={loading}
        type={ButtonType.Text}
        icon={SVGAsset.RemoveTag}
        onClick={onClick}
      />
    </Layout>
  );
};
