import * as React from "react";

import { FETCH_DETAILED_USER_FIELDS } from "aegis/features/account-info/container";
import {
  UPDATE_PARTNER_ESCALATION_LIST_QUERY,
  UpdatePartnerEscalationListMutation,
  UpdateType
} from "aegis/features/partner-escalation/mutations";
import { WithConfirmationModal } from "aegis/functionality/components/confirmation-modal";
import { apolloErrorHandler } from "aegis/functionality/error-notifications";
import { DetailedUser } from "aegis/models";
import { PartnerEscalationComponent } from "./component";

export interface Props {
  user: DetailedUser;
}

export const PartnerEscalation: React.SFC<Props> = ({ user }) => {
  if (!user.isEscalatePartner) {
    return null;
  }

  return (
    <UpdatePartnerEscalationListMutation
      mutation={UPDATE_PARTNER_ESCALATION_LIST_QUERY}
      onError={apolloErrorHandler(`Failed to remove ${user.login} from list`)}
      refetchQueries={[
        {
          query: FETCH_DETAILED_USER_FIELDS,
          variables: {
            id: user.id
          }
        }
      ]}
    >
      {(mutation, { loading }) => {
        const removeUser = () => {
          mutation({ variables: { input: { loginOrIDs: [user.id], type: UpdateType.Remove } } });
        };

        return (
          <WithConfirmationModal
            title={`Removing escalated partner`}
            body={`Are you sure to remove ${user.login} from escalated partner list?`}
            confirmLabelOverride="Remove"
            onConfirm={removeUser}
          >
            {confirm => <PartnerEscalationComponent loading={loading} onClick={confirm} />}
          </WithConfirmationModal>
        );
      }}
    </UpdatePartnerEscalationListMutation>
  );
};
