import * as React from "react";

import gql from "graphql-tag";
import { Mutation } from "react-apollo";

import { FETCH_DETAILED_USER_FIELDS } from "aegis/features/account-info/container";
import { DetailedUserFields } from "aegis/fragments";
import { DetailedUser } from "aegis/models";
import { StrikeDetailsComponent } from "./component";

export const UNBAN_USER_MUTATION = gql`
  mutation Unban($input: UnbanUserInput!) {
    unbanUser(input: $input) {
      user {
        ...DetailedUserFields
      }
    }
  }
  ${DetailedUserFields}
`;

type UnbanUserInput = {
  input: {
    userID: string;
    decrementCount: number;
    decrementTOS: boolean;
    decrementDMCA: boolean;
  };
};

type UnbanUserPayload = {
  unbanUser: {
    user?: DetailedUser;
  };
};

export interface Props {
  user: DetailedUser;
}

export class UnbanUserMutation extends Mutation<UnbanUserPayload, UnbanUserInput> {}

export const StrikeDetails: React.SFC<Props> = ({ user }) => {
  return (
    <UnbanUserMutation
      mutation={UNBAN_USER_MUTATION}
      refetchQueries={[
        {
          query: FETCH_DETAILED_USER_FIELDS,
          variables: {
            id: user.id
          }
        }
      ]}
    >
      {unbanUserMutation => {
        const unbanUser = (decrementCount: number, decrementTOS: boolean, decrementDMCA: boolean) => {
          unbanUserMutation({
            variables: {
              input: {
                userID: user.id,
                decrementCount: decrementCount,
                decrementDMCA: decrementDMCA,
                decrementTOS: decrementTOS
              }
            }
          });
        };
        return <StrikeDetailsComponent user={user} onUnban={unbanUser} />;
      }}
    </UnbanUserMutation>
  );
};
