import * as React from "react";

import gql from "graphql-tag";

import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { DetailedUser } from "aegis/models";
import { Color, CoreText } from "twitch-core-ui";
import { AccountInfoComponent } from "./component";

export interface PublicProps {
  id?: string;
}

export const FETCH_DETAILED_USER_FIELDS = gql`
  query userCard($id: ID, $login: String) {
    user(id: $id, login: $login) {
      ...UserFields
      ...DetailedUserFields
    }
  }
  ${Fragments.UserFields}
  ${Fragments.DetailedUserFields}
`;

type Variables = {
  id: string;
};

interface Data {
  user: DetailedUser;
}

class AccountInfoQuery extends Query<Data, Variables> {}

export const AccountInfo: React.SFC<PublicProps> = ({ id }) => {
  return (
    <AccountInfoQuery
      displayName="AccountInfo"
      query={FETCH_DETAILED_USER_FIELDS}
      variables={{ id: id ? id : "" }}
      errorPolicy="none"
    >
      {({ loading, error, data }) => {
        if (error) {
          console.error("AccountInfo-DetailedUserFieldsQuery", error);
          return <CoreText color={Color.Error}>Error loading user information</CoreText>;
        }

        return <AccountInfoComponent loading={loading} user={data && data.user} id={id} />;
      }}
    </AccountInfoQuery>
  );
};
