import * as React from "react";

import { AltLookUpStore } from "aegis/stores/altLookUpStore";
import { inject, observer } from "mobx-react";
import { AlignItems, Button, CoreText, Display, Layout } from "twitch-core-ui";

export interface Props {
  altLookUpStore?: AltLookUpStore;
}

export enum TestSelectors {
  SelectedCount = "link-to-chat-activity--selected-count",
  ButtonLink = "link-to-chat-activity--button-link"
}

@inject("altLookUpStore")
@observer
export class LinkToChatActivity extends React.Component<Props> {
  public render() {
    const { altLookUpStore } = this.props;
    const disabled = !altLookUpStore!.numberSelectedUsers;

    return (
      altLookUpStore!.altUsers.length > 0 && (
        <Layout display={Display.InlineFlex} alignItems={AlignItems.Baseline}>
          <CoreText data-test-selector={TestSelectors.SelectedCount}>
            {`${altLookUpStore!.numberSelectedUsers} users selected.`}
          </CoreText>
          <Layout padding={1}>
            <Button
              data-track-click="alt-lookup-link-to-chat-activity"
              linkTo={`/chatactivity?users=${altLookUpStore!.selectedUsers.join(",")}`}
              data-test-selector={TestSelectors.ButtonLink}
              disabled={disabled}
            >
              {"Check Chat Activity"}
            </Button>
          </Layout>
        </Layout>
      )
    );
  }
}
