import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockAltUserInfo } from "aegis/models/mocks/altuserinfo";
import { AltLookupTableRow, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Alt lookup table row", () => {
  it("renders", () => {
    const wrapper = Enzyme.shallow(<AltLookupTableRow altUser={MockAltUserInfo()} index={0} />);

    expect(wrapper.find({ "data-test-selector": TestSelectors.CreatedAt })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Match })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.StrikeButton })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Type })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.User })).toHaveLength(1);
  });

  it("fires onCheck prop when changed", () => {
    const onCheck = jest.fn();
    const wrapper = Enzyme.shallow(<AltLookupTableRow altUser={MockAltUserInfo()} onCheck={onCheck} index={1} />);
    wrapper.find({ "data-test-selector": TestSelectors.CheckBox }).simulate("change");
    expect(onCheck).toBeCalled();
  });
});
