import * as React from "react";

import {
  BalloonDirection,
  ButtonType,
  CheckBox,
  Layout,
  TableCell,
  TableRow,
  TextAlign,
  VerticalAlign
} from "twitch-core-ui";

import { StrikeButton } from "aegis/features/strike-button";
import { User } from "aegis/features/user";
import { AltUserInfo } from "aegis/models";

export interface Props {
  altUser: AltUserInfo;
  index: number;
  onCheck?: () => void;
  refDelegate?: (e: HTMLInputElement) => void;
}

export enum TestSelectors {
  CheckBox = "alt-lookup-table-row--check-box",
  CreatedAt = "alt-lookup-table-row--created-at",
  Match = "alt-lookup-table-row--match",
  StrikeButton = "alt-lookup-table-row--strike-button",
  Type = "alt-lookup-table-row--strike-type",
  User = "alt-lookup-table-row--user"
}

export const AltLookupTableRow: React.SFC<Props> = ({ altUser, index, refDelegate, onCheck }) => {
  const { type, user, matched } = altUser;
  return (
    <TableRow data-key={index} data-alt-look-up-row="alt-look-up-row">
      <Layout className="tw-table-cell" textAlign={TextAlign.Center} verticalAlign={VerticalAlign.Middle}>
        <Layout padding={1}>
          <CheckBox
            data-track-click="alt-lookup-toggle-individual"
            label={""}
            onChange={onCheck}
            refDelegate={refDelegate}
            data-test-selector={TestSelectors.CheckBox}
          />
        </Layout>
      </Layout>
      <TableCell>
        <User
          data-test-selector={TestSelectors.User}
          user={user}
          inline={true}
          showStatus={true}
          showType={true}
          balloonDirection={BalloonDirection.BottomLeft}
        />
      </TableCell>
      <TableCell data-test-selector={TestSelectors.Type}>{type.join(", ")}</TableCell>
      <TableCell>
        <User data-test-selector={TestSelectors.Match} user={matched} inline={true} showStatus={true} showType={true} />
      </TableCell>
      <TableCell data-test-selector={TestSelectors.CreatedAt}>{user.createdAt}</TableCell>
      <TableCell>
        <StrikeButton
          data-test-selector={TestSelectors.StrikeButton}
          type={ButtonType.Hollow}
          user={user}
          banFormProps={{
            targetUserID: user.id,
            targetUser: user.login,
            defaultContent: "general",
            defaultReason: "other",
            defaultDetailedReason: "inappropriate_username"
          }}
        />
      </TableCell>
    </TableRow>
  );
};
