import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockAutoResolve } from "aegis/models/mocks";
import { AutoResolve, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });
describe("Active Auto Resolve", () => {
  it("renders with optional fields", () => {
    const wrapper = Enzyme.shallow(<AutoResolve autoResolve={MockAutoResolve()} />);

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.Countdown }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.ResolveCount }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Reporter }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Target }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Content }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Reason }).length).toBe(1);
  });

  it("renders with optional fields missing", () => {
    const wrapper = Enzyme.shallow(
      <AutoResolve
        autoResolve={MockAutoResolve({
          fromUser: undefined,
          targetUser: undefined,
          content: undefined,
          reason: undefined
        })}
      />
    );

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.Countdown }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.ResolveCount }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Reporter }).length).toBe(0);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Target }).length).toBe(0);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Content }).length).toBe(0);
    expect(wrapper.find({ "data-test-selector": TestSelectors.Reason }).length).toBe(0);
  });
});
