import * as React from "react";

import { AlignItems, Background, Display, InjectStyledLayout, JustifyContent, SVG, SVGAsset } from "twitch-core-ui";

import "./styles.scss";

export interface Props {
  onClick: () => void;
  loading: boolean;
}

export const DisableAutoResolveButtonComponent: React.SFC<Props> = ({ onClick, loading }) => {
  return (
    <InjectStyledLayout
      background={Background.Alt2}
      className="disable-auto-resolve-button"
      fullHeight
      fullWidth
      display={Display.Flex}
      alignItems={AlignItems.Center}
      justifyContent={JustifyContent.Center}
    >
      <div
        onClick={() => {
          if (!loading) {
            onClick();
          }
        }}
      >
        {!loading && <SVG asset={SVGAsset.Trash} />}
        {loading && <i className={"fa fa-spinner"} />}
      </div>
    </InjectStyledLayout>
  );
};
