import * as React from "react";

import gql from "graphql-tag";
import { Mutation } from "react-apollo";

import { apolloErrorHandler } from "aegis/functionality/error-notifications";
import { DisableAutoResolveButtonComponent } from "./component";

export interface Props {
  id: string;
}

export type DisableAutoResolveResponse = {
  disableAutoResolve: {
    success: boolean;
  };
};

export type DisableAutoResolveInput = {
  input: {
    id: string;
  };
};

export const DISABLE_AUTO_RESOLVE = gql`
  mutation disableAutoResolve($input: DisableAutoResolveInput!) {
    disableAutoResolve(input: $input) {
      success
    }
  }
`;

export class DisableAutoResolveMutation extends Mutation<DisableAutoResolveResponse, DisableAutoResolveInput> {}

export class DisableAutoResolveButton extends React.Component<Props> {
  public render() {
    const { id } = this.props;
    return (
      <DisableAutoResolveMutation
        mutation={DISABLE_AUTO_RESOLVE}
        onError={apolloErrorHandler("Failed to disable autoresolve rule")}
      >
        {(disableAutoResolveQuery, { loading }) => {
          return (
            <DisableAutoResolveButtonComponent
              onClick={() => {
                disableAutoResolveQuery({ variables: { input: { id: id } } });
              }}
              loading={loading}
            />
          );
        }}
      </DisableAutoResolveMutation>
    );
  }
}
