import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { AutoResolveUserType } from "aegis/models";
import { MockAutoResolveUser } from "aegis/models/mocks";
import { AutoResolveUser, TestSelectors, UserType } from ".";

Enzyme.configure({ adapter: new Adapter() });
describe("Active Auto Resolve", () => {
  it("renders target user", () => {
    const user = MockAutoResolveUser();
    const wrapper = Enzyme.shallow(<AutoResolveUser user={user} type={UserType.TARGET} />);

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.UserLink }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.UserType }).props().children).toEqual(["", "target"]);
  });

  it("renders not target user", () => {
    const user = MockAutoResolveUser();
    user.type = AutoResolveUserType.NOT.toString();
    const wrapper = Enzyme.shallow(<AutoResolveUser user={user} type={UserType.TARGET} />);

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.UserLink }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.UserType }).props().children).toEqual(["not ", "target"]);
  });

  it("renders reporter", () => {
    const user = MockAutoResolveUser();
    const wrapper = Enzyme.shallow(<AutoResolveUser user={user} type={UserType.REPORTER} />);

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.UserLink }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.UserType }).props().children).toEqual(["", "reporter"]);
  });

  it("renders not reporter", () => {
    const user = MockAutoResolveUser();
    user.type = AutoResolveUserType.NOT.toString();
    const wrapper = Enzyme.shallow(<AutoResolveUser user={user} type={UserType.REPORTER} />);

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.UserLink }).length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.UserType }).props().children).toEqual([
      "not ",
      "reporter"
    ]);
  });
});
