import * as React from "react";

import { UserCardLink } from "aegis/features/user-card/user-link";
import { AutoResolveUser as AutoResolveUserModel, AutoResolveUserType } from "aegis/models";
import {
  AlignItems,
  BalloonDirection,
  Color,
  CoreLink,
  CoreText,
  Display,
  FontSize,
  JustifyContent,
  Layout,
  StyledLayout
} from "twitch-core-ui";

import "./styles.scss";

export enum UserType {
  REPORTER,
  TARGET
}

export interface Props {
  user: AutoResolveUserModel;
  type: UserType;
}

export enum TestSelectors {
  UserType = "user-type",
  UserLink = "user-link"
}

export const AutoResolveUser: React.SFC<Props> = ({ user, type }) => {
  const userRuleTypeText = user.type === AutoResolveUserType.NOT.toString() ? "not " : "";
  let userTypeText: string;

  switch (type) {
    case UserType.REPORTER: {
      userTypeText = "reporter";
      break;
    }
    case UserType.TARGET: {
      userTypeText = "target";
      break;
    }
    default:
      console.error("Unrecognized auto resolve user type ", type);
      userTypeText = `UNKNOWN ${type}`;
  }

  return (
    <Layout display={Display.Flex} justifyContent={JustifyContent.Start} alignItems={AlignItems.Center}>
      <StyledLayout display={Display.InlineBlock}>
        <UserCardLink
          userID={user.user.id}
          ballonPropsOverride={{ direction: BalloonDirection.BottomRight }}
          data-test-selector={TestSelectors.UserLink}
        >
          <CoreLink className="auto-resolve-user__link_text">
            <CoreText fontSize={FontSize.Size6} ellipsis className="auto-resolve-user">
              {user.user.login}
            </CoreText>
          </CoreLink>
        </UserCardLink>
      </StyledLayout>
      <Layout display={Display.Flex} alignItems={AlignItems.Center} padding={{ left: 0.5 }}>
        <CoreText color={Color.Alt2} fontSize={FontSize.Size8} data-test-selector={TestSelectors.UserType}>
          {userRuleTypeText}
          {userTypeText}
        </CoreText>
      </Layout>
    </Layout>
  );
};
