import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockAdmin } from "aegis/models/mocks";
import { BanException } from "./component";

Enzyme.configure({ adapter: new Adapter() });
describe("Ban Exception", () => {
  it("renders", () => {
    const wrapper = Enzyme.shallow(
      <BanException
        banException={{
          id: "id",
          reason: "reason",
          createdAt: "2018-01-01T12:23:34Z",
          createdBy: MockAdmin()
        }}
      />
    );

    expect(wrapper).toMatchSnapshot();
  });

  it("renders without created by", () => {
    const wrapper = Enzyme.shallow(
      <BanException
        banException={{
          id: "id",
          reason: "reason",
          createdAt: "2018-01-01T12:23:34Z"
        }}
      />
    );

    expect(wrapper).toMatchSnapshot();
  });
});
