import * as React from "react";

import { BanException as BanExceptionModel } from "aegis/models";
import { AlignItems, Color, CoreText, Display, FlexDirection, Layout, SVG, SVGAsset, TextType } from "twitch-core-ui";

export interface Props {
  banException: BanExceptionModel;
}

export const BanException: React.SFC<Props> = ({ banException }) => {
  return (
    <Layout display={Display.Flex} flexDirection={FlexDirection.Column} alignItems={AlignItems.Start}>
      <Layout alignItems={AlignItems.Center} display={Display.Flex}>
        <SVG asset={SVGAsset.NotificationInfo} />
        <CoreText type={TextType.Span} color={Color.Error} bold>
          &nbsp;DO NOT BAN!
        </CoreText>
      </Layout>
      <Layout className="aegis-pill__reason" margin={{ y: 0.5 }}>
        <CoreText>{banException.reason}</CoreText>
      </Layout>
      <CoreText> By {banException.createdBy ? banException.createdBy.ldap : "Unknown"} </CoreText>
    </Layout>
  );
};
