import * as React from "react";

import * as Enzyme from "enzyme";
import { mount } from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { wrapWithGQLProvider } from "aegis/tests/graphql";
import { mockedBanFormQueries } from "../mocks";
import { BAN_FORM_HEADER_TEST_SELECTOR, BanFormModal } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Portal Modal", () => {
  let wrapper: Enzyme.ReactWrapper;

  const modalRoot = document.createElement("div");
  modalRoot.setAttribute("id", "portal-modal-root");
  const body = document.querySelector("body");
  if (body) {
    body.appendChild(modalRoot);
  }

  afterEach(() => {
    wrapper.unmount();
  });

  it("renders in the PortalModalRoot without a user", () => {
    wrapper = mount(
      wrapWithGQLProvider(<BanFormModal closeModal={jest.fn()} />, mockedBanFormQueries).wrappedComponent
    );
    expect(
      wrapper
        .find({ "data-test-selector": BAN_FORM_HEADER_TEST_SELECTOR })
        .first()
        .text()
    ).toBe("Strike ");
  });
});
