import * as React from "react";

import { AncestorName, AncestorNameContextProvider } from "aegis/context/ancestor";
import { openStrikeFormInNewTab } from "aegis/features/strike-button/utils";
import {
  AlignContent,
  AlignItems,
  Background,
  Button,
  ButtonType,
  CoreText,
  Display,
  JustifyContent,
  Layout,
  StyledLayout,
  SVGAsset,
  TextType
} from "twitch-core-ui";
import { BanForm, PublicProps as BanFormProps } from "../component";

import "./styles.scss";

export const BAN_FORM_HEADER_TEST_SELECTOR = "header-test-selector";

interface PublicProps {
  displayName?: string;
  closeModal?: () => void;
}
export type Props = PublicProps & BanFormProps;

export class BanFormModal extends React.Component<Props> {
  public render() {
    const { displayName, targetUser } = this.props;

    const name = displayName ? displayName : targetUser; // Fallback on targetUser login if no displayName passed
    return (
      <AncestorNameContextProvider ancestorName={AncestorName.StrikeModal}>
        <StyledLayout className="banform-modal" alignContent={AlignContent.Center} alignItems={AlignItems.Center}>
          <StyledLayout background={Background.Base} fullHeight={true} alignContent={AlignContent.Center} padding={1}>
            <Layout display={Display.Flex} justifyContent={JustifyContent.Between}>
              <CoreText type={TextType.H3} data-test-selector={BAN_FORM_HEADER_TEST_SELECTOR}>
                {"Strike " + (name ? name : "")}
              </CoreText>
              <Button
                data-track-click="ban-form-modal-open-new-tab"
                onClick={this.openInNewTab}
                type={ButtonType.Hollow}
                icon={SVGAsset.Popout}
              >
                Open in new tab
              </Button>
            </Layout>
            <BanForm
              targetUserID=""
              description=""
              defaultContent=""
              defaultReason=""
              defaultDetailedReason=""
              locationOfContent=""
              targetUser=""
              placeholders={{ chatlog: "" }}
              {...this.props}
            />
          </StyledLayout>
        </StyledLayout>
      </AncestorNameContextProvider>
    );
  }

  private openInNewTab = () => {
    openStrikeFormInNewTab(this.props);
    if (this.props.closeModal) {
      this.props.closeModal();
    }
  };
}
