import * as React from "react";

import { ImageDisplay, ImageStore, ImageUploader } from "aegis/features/images";
import { FormGroup, FormGroupOrientation, Layout } from "twitch-core-ui";

export interface Props {
  onUploadComplete: (comment: string) => void;
  linksInDescription: string[];
  targetUserID?: string;
}

export class BanformImageUploader extends React.Component<Props> {
  private screenshotStore: ImageStore;
  private uploadedImages: string | undefined;

  constructor(props: Props) {
    super(props);
    this.screenshotStore = new ImageStore();
  }

  public render() {
    return (
      <Layout padding={1} className="banform-image-uploader">
        <FormGroup label={"Add Additional Screenshots"} orientation={FormGroupOrientation.Horizontal}>
          <ImageDisplay
            store={this.screenshotStore}
            hideComments
            excludedImagesURLs={this.getExcludedImages()}
            imageUploaded={this.imageUploaded}
          />
          <ImageUploader
            store={this.screenshotStore}
            imageUploaded={this.imageUploaded}
            targetUserID={this.props.targetUserID}
          />
        </FormGroup>
      </Layout>
    );
  }

  private imageUploaded = (imageURLAndComment: string) => {
    this.uploadedImages = this.uploadedImages ? this.uploadedImages + "\n\n" + imageURLAndComment : imageURLAndComment;
    if (this.screenshotStore.doneUploading) {
      this.props.onUploadComplete(this.uploadedImages);
      this.uploadedImages = undefined;
    }
  };

  private getExcludedImages = (): string[] => {
    const imageURLs = this.screenshotStore.uploadedImages.map(({ imageURL }) => {
      return imageURL!;
    });
    return imageURLs.filter(url => {
      return !this.props.linksInDescription.includes(url!);
    });
  };
}
