import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { BanFormStore } from "./store";

Enzyme.configure({ adapter: new Adapter() });

const placeholderDescription =
  "ᐸCHATLOG_COPY_PASTAᐳ ᐸWHISPERLOG_COPY_PASTAᐳ ᐸORIG_REPORT_CASEIDᐳ " +
  "ᐸLOCATION_OF_CONTENTᐳ ᐸSCREENSHOT_LINKᐳ ᐸCONTENT_COPY_PASTAᐳ ";

describe("Banform Mobx Store", () => {
  it("does nothing if placeholders are empty", () => {
    const store = new BanFormStore();

    store.updatePlaceholders({});
    store.updateDescription(placeholderDescription);

    expect(store.replacePlaceholders()).toEqual(placeholderDescription);
  });

  it("replaces placeholders if provided", () => {
    const store = new BanFormStore();

    store.updatePlaceholders({
      chatlog: "chatlogs",
      whisper: "whispers",
      reportID: "report_id",
      locationOfContent: "location",
      screenshotLinks: "screenshot",
      content: "content"
    });
    store.updateDescription(placeholderDescription);

    expect(store.replacePlaceholders()).toMatchSnapshot();
  });

  it("appends placeholders if template does not include placeholder text", () => {
    const store = new BanFormStore();

    store.updatePlaceholders({
      chatlog: "chatlogs",
      whisper: "whispers",
      reportID: "report_id",
      locationOfContent: "location",
      screenshotLinks: "screenshot",
      content: "content"
    });
    store.updateDescription("description");

    expect(store.replacePlaceholders()).toMatchSnapshot();
  });
});
