import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { Button, CoreLink, TableCell, TableHeading } from "twitch-core-ui";
import { mockBountyInfo } from "../../mocks";
import { BountyCampaignDetailsComponent, Props, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

function defaultPropsGenerator(overrides?: Partial<Props>): Props {
  return {
    campaign: mockBountyInfo(1)[0].campaign,
    onCancel: jest.fn(),
    ...overrides
  };
}

const setupShallow = (overrides?: Partial<Props>) => {
  const props = defaultPropsGenerator(overrides);
  return Enzyme.shallow(<BountyCampaignDetailsComponent {...props} />);
};

describe("BountyCampaignDetailsComponent", () => {
  it("renders button properly", () => {
    const wrapper = setupShallow();
    expect(wrapper.find(Button).length).toBe(1);
  });

  it(`renders the proper cells with campaign`, () => {
    const campaign = mockBountyInfo(1)[0].campaign;
    const wrapper = setupShallow({ campaign: campaign });

    expect(wrapper.find(TableHeading).length).toEqual(8);
    expect(wrapper.find(TableCell).length).toEqual(8);
    // title
    expect(wrapper.find({ "data-test-selector": TestSelectors.TitleColumn }).html()).toContain(campaign.title);
    // sponsor
    expect(wrapper.find({ "data-test-selector": TestSelectors.SponsorColumn }).html()).toContain(campaign.sponsor);
    // campaign type
    expect(wrapper.find({ "data-test-selector": TestSelectors.TypeColumn }).html()).toContain(campaign.type);
    // required streamLengthSeconds
    expect(wrapper.find({ "data-test-selector": TestSelectors.StreamLengthSecondsColumn }).html()).toContain(
      campaign.streamLengthSeconds
    );
    // campaign fetails
    expect(wrapper.find({ "data-test-selector": TestSelectors.DetailsColumn }).html()).toContain(campaign.details);
    // game
    expect(wrapper.find({ "data-test-selector": TestSelectors.GameColumn }).html()).toContain(
      campaign.game.displayName
    );
    // videos
    const videos = campaign.video;
    if (videos) {
      expect(
        wrapper
          .find({ "data-test-selector": TestSelectors.VideoColumn })
          .find(CoreLink)
          .prop("to")
      ).toBe(videos[0].url);
    }
  });
});
