import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { TableHeading } from "twitch-core-ui";
import { mockBountyInfo } from "../../mocks";
import { BountyRow } from "../bounties-table-row";
import { BountiesTableComponent, Props } from "./component";

Enzyme.configure({ adapter: new Adapter() });

function defaultPropsGenerator(overrides?: Partial<Props>): Props {
  return {
    pendingBounties: mockBountyInfo(),
    ...overrides
  };
}

const setupShallow = (overrides?: Partial<Props>) => {
  const props = defaultPropsGenerator();
  return Enzyme.shallow(<BountiesTableComponent {...props} {...overrides} />);
};

describe("Bounty approval table", () => {
  it("renders correctly the table headings", () => {
    const wrapper = setupShallow();
    expect(wrapper.find(TableHeading).length).toEqual(10);
  });

  it("renders the proper amount of rows", () => {
    const wrapper = setupShallow();
    expect(wrapper.find(BountyRow).length).toEqual(3);
  });
});
