import * as React from "react";

import { BountyRow } from "aegis/features/bounties/components/bounties-table-row";
import { BountyInfo } from "aegis/features/bounties/models";
import { Table, TableBody, TableHeader, TableHeading } from "twitch-core-ui";

export interface PublicProps {
  pendingBounties: BountyInfo[];
}

export type Props = PublicProps;

export class BountiesTableComponent extends React.Component<Props> {
  public render() {
    const { pendingBounties } = this.props;

    const rows: JSX.Element[] = pendingBounties.map(bounty => (
      <BountyRow key={`bounty-row-${bounty.id}`} bounty={bounty} />
    ));

    return (
      <Table>
        <TableHeader>
          <TableHeading label="ID" />
          <TableHeading label="Stream Title" />
          <TableHeading label="UserId" />
          <TableHeading label="Language" />
          <TableHeading label="Country" />
          <TableHeading label="Campaign" />
          <TableHeading label="Vod" />
          <TableHeading label="Other Vods" />
          <TableHeading label="Approve" />
          <TableHeading label="Reject & Reason" />
        </TableHeader>
        <TableBody>{rows}</TableBody>
      </Table>
    );
  }
}

export const BountiesTable: React.ComponentClass<PublicProps> = BountiesTableComponent;
