import { PendingBountiesTable } from "aegis/features/bounties/components/bounties-table/container";
import * as React from "react";
import { CoreText, Display, FormGroup, JustifyContent, Layout, Select, TextType } from "twitch-core-ui";
import { BountyBoardSelectTag } from "../bounties-select-tag-field";
import "./styles.scss";

export const ALL_BUCKET = "ALL";
export const DEFAULT_BUCKET_COUNT = 3;
export const ALL_BUCKET_STATE = {
  bucketCount: 1,
  currentBucket: 0
};

export const DEFAULT_STATE = {
  currentBucket: 0,
  bucketCount: 3,
  selectedLanguages: []
};

export interface PublicProps {
  supportedLanguages: string[];
}

interface State {
  currentBucket: number;
  bucketCount: number;
  selectedLanguages: string[];
}

class PendingBountiesComponent extends React.Component<PublicProps, State> {
  public state: State = {
    ...DEFAULT_STATE
  };

  public render() {
    const { supportedLanguages } = this.props;
    const { selectedLanguages } = this.state;

    return (
      <Layout padding={2}>
        <CoreText type={TextType.H2}>Bounties</CoreText>
        <Layout display={Display.Flex} justifyContent={JustifyContent.Between}>
          <Layout display={Display.Flex} padding={{ y: 1 }}>
            <Layout className="bounty-approval--select" margin={{ right: 1 }}>
              <FormGroup label="Bucket">
                <Select onChange={this.onBucketChange}>
                  <option value={0}>Bucket 1</option>
                  <option value={1}>Bucket 2</option>
                  <option value={2}>Bucket 3</option>
                  <option value={ALL_BUCKET}>All</option>
                </Select>
              </FormGroup>
            </Layout>
            <Layout className="bounty-approval--select" margin={{ right: 1 }}>
              <BountyBoardSelectTag
                label="Language"
                buttonLabel="Add Languages"
                value={selectedLanguages}
                options={supportedLanguages}
                disabled={false}
                onChange={this.onSelectLanguage}
              />
            </Layout>
          </Layout>
        </Layout>
        <PendingBountiesTable
          currentBucket={this.state.currentBucket}
          bucketCount={this.state.bucketCount}
          languages={this.state.selectedLanguages}
        />
      </Layout>
    );
  }

  private onSelectLanguage = (selectedLanguages: string[]) => {
    this.setState({ selectedLanguages });
  };

  private onBucketChange = (e: React.FormEvent<HTMLSelectElement>) => {
    this.setState(getBucketState(e.currentTarget.value));
  };
}

/**
 * getBucketState takes in the selected bucket value and returns the proper state.
 * This function checks for the ALL_BUCKET value and returns the ALL_BUCKET_STATE constant which forces
 * the bucketCount to 1 and the currentBucket to 0. Otherwise it parses selectValue into an int which is used
 * as the currentBucket value and sets the bucketCount to DEFAULT_BUCKET_COUNT.
 * @param selectValue A string containing the bucket <option> value
 */
export function getBucketState(selectValue: string): Pick<State, "currentBucket" | "bucketCount"> {
  if (selectValue === ALL_BUCKET) {
    return ALL_BUCKET_STATE;
  }

  const val: number = Number(selectValue);
  if (!isNaN(val)) {
    return {
      currentBucket: val,
      bucketCount: DEFAULT_BUCKET_COUNT
    };
  }

  return DEFAULT_STATE;
}

export const PendingBounties: React.ComponentClass<PublicProps> = PendingBountiesComponent;
