import * as React from "react";

import { Query } from "aegis/functionality/apollo-wrapper";
import gql from "graphql-tag";

import { BountyLanguage } from "aegis/features/bounties/models";
import { Color, CoreText } from "twitch-core-ui";
import { PendingBounties } from "./component";

export interface PublicProps {}
const FETCH_BOUNTY_LANGUAGES = gql`
  query bountyLanguages {
    bountyLanguages {
      language
    }
  }
`;

interface Data {
  bountyLanguages: BountyLanguage[];
}

class BountiesQuery extends Query<Data, {}> {}

export const Bounties: React.SFC<PublicProps> = () => {
  return (
    <BountiesQuery displayName="Bounties" query={FETCH_BOUNTY_LANGUAGES} errorPolicy="none">
      {({ error, data }) => {
        if (error) {
          console.error("Bounties-BountyLanguagesQuery", error);
          return <CoreText color={Color.Error}>Error loading bounty languages</CoreText>;
        }

        let languages: string[] = [];
        if (data && data.bountyLanguages) {
          languages = data.bountyLanguages.map(bountyLanguage => bountyLanguage.language);
        }
        return <PendingBounties supportedLanguages={languages} />;
      }}
    </BountiesQuery>
  );
};
