import { BountyCampaignType, BountyInfo, PendingBountiesResponse } from "aegis/features/bounties/models";

export function mockBountyInfo(count?: number): BountyInfo[] {
  let mockData = [
    {
      id: "test_bounty_id_1",
      streamTitles: "#sponsored test_bounty_id_1",
      platform: undefined,
      vod: {
        id: "",
        createdAt: "",
        isDeleted: false,
        title: "",
        unmutedURL: "",
        url: "https://player.twitch.tv/?autoplay=false&time=2h40m42s&video=123"
      },
      vods: undefined,
      broadcasterInfo: {
        userID: "test user id 1",
        country: "US",
        language: "en"
      },
      campaign: {
        title: "test campaign title 1",
        sponsor: "test sponsor 1",
        type: BountyCampaignType.MISC_TRAILER,
        streamLengthSeconds: 120,
        availablePlatforms: undefined,
        details: "test details 1",
        game: {
          id: "test game id",
          displayName: "test game 1"
        }
      },
      bountyCampaignVideo: [
        {
          country: "US",
          url: "www.twitch.tv"
        }
      ]
    },
    {
      id: "test_bounty_id_2",
      streamTitles: "#sponsored test_bounty_id_2",
      platform: undefined,
      vod: {
        id: "",
        createdAt: "",
        isDeleted: false,
        title: "",
        unmutedURL: "",
        url: "https://player.twitch.tv/?autoplay=false&time=2h40m42s&video=123"
      },
      vods: ["www.twitch.tv/test_bounty_id_2"],
      broadcasterInfo: {
        userID: "test user id 2",
        country: "US",
        language: "en"
      },
      campaign: {
        title: "test campaign title 2",
        sponsor: "test sponsor 2",
        type: BountyCampaignType.MISC_TRAILER,
        streamLengthSeconds: 120,
        availablePlatforms: undefined,
        details: "test details 2",
        game: {
          id: "test game id 2",
          displayName: "test game 2"
        }
      },
      bountyCampaignVideo: [
        {
          country: "US",
          url: "www.twitch.tv"
        }
      ]
    },
    {
      id: "test_bounty_id_3",
      streamTitles: "#sponsored test_bounty_id_3",
      platform: "PC",
      vod: {
        id: "",
        createdAt: "",
        isDeleted: false,
        title: "",
        unmutedURL: "",
        url: "https://player.twitch.tv/?autoplay=false&time=2h40m42s&video=123"
      },
      vods: ["www.twitch.tv/test_bounty_id_3", "www.twitch.tv/test_bounty_id_4"],
      broadcasterInfo: {
        userID: "test user id 3",
        country: "US",
        language: "en"
      },
      campaign: {
        title: "test campaign title 3",
        sponsor: "test sponsor 3",
        type: BountyCampaignType.PAY_TO_STREAM,
        streamLengthSeconds: 120,
        availablePlatforms: ["PC", "PS4"],
        details: "test details 3",
        game: {
          id: "test game id 3",
          displayName: "test game 3"
        }
      },
      bountyCampaignVideo: undefined
    }
  ];
  if (count) {
    mockData = mockData.slice(0, count);
  }
  return mockData;
}

export function mockPendingBountiesResponse(count?: number): PendingBountiesResponse {
  return {
    pendingBounties: mockBountyInfo(count)
  };
}
