import { Vod } from "aegis/models";

export interface BountyInfo {
  id: string;
  streamTitles: string;
  platform?: string;
  vod?: Vod;
  vods?: string[];
  broadcasterInfo: BroadcasterInfo;
  campaign: BountyCampaign;
}

export interface BroadcasterInfo {
  userID: string;
  country?: string;
  language?: string;
}

export interface BountyCampaign {
  title?: string;
  sponsor?: string;
  type: BountyCampaignType;
  streamLengthSeconds: number;
  displayName?: string;
  availablePlatforms?: string[];
  details: string;
  game: Game;
  video?: BountyCampaignVideo[];
}

export interface Game {
  id: string;
  displayName: string;
}

export interface BountyCampaignVideo {
  title: string;
  country: string;
  url: string;
}

export enum BountyModerationStatusOption {
  APPROVE = "PASS",
  REJECT = "FAIL"
}

export interface ReviewPendingBountyInput {
  input: {
    bountyID: string;
    moderationStatus: BountyModerationStatusOption;
    reason?: BountyFailReason;
  };
}

export interface ReviewPendingBountyResponse {
  bounty: {
    bountyID: string;
    moderationStatus: string;
    moderationFailReason?: string;
    lastModeratedTime: Date;
  };
}

export interface PendingBountiesResponse {
  pendingBounties: BountyInfo[];
}

export enum BountyCampaignType {
  PAY_TO_STREAM = "PAY_TO_STREAM",
  MISC_TRAILER = "MISC_TRAILER"
}

export enum BountyFailReason {
  MINIMUM_TIME_NOT_MET = "MinimumTimeNotMeet",
  INCORRECT_CONTENT = "IncorrectContent",
  BADMOUTHING = "BadMouthing",
  OTHER_CONTENT_VISIBLE = "OtherContentVisible",
  IDLE = "Idle",
  NO_VOD = "NoVod",
  OTHER = "Other"
}

export interface BountyLanguage {
  language: string;
}
