import * as React from "react";

import { shallow } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockDetailedUser } from "aegis/models/mocks";
import { MultiUserInput, PublicProps } from "./component";
import { UserPill } from "./user-pill";

Enzyme.configure({ adapter: new Adapter() });

const setup = (overrides?: Partial<PublicProps>) => {
  const props: PublicProps = {
    onCloseGenerator: jest.fn(),
    chatters: [MockDetailedUser({ id: "user1" }), MockDetailedUser({ id: "user2" }), MockDetailedUser({ id: "user3" })],
    ...overrides
  };

  return {
    props,
    wrapper: shallow(<MultiUserInput {...props} />)
  };
};

describe("MultiUserInput", () => {
  it("renders", () => {
    const { wrapper } = setup();

    expect(wrapper.find(UserPill)).toHaveLength(3);
  });

  it("provides each UserPill with an onClickClose prop", () => {
    const { props } = setup();
    expect(props.onCloseGenerator).toHaveBeenCalledTimes(3);
    expect(props.onCloseGenerator).nthCalledWith(1, 0);
    expect(props.onCloseGenerator).nthCalledWith(2, 1);
    expect(props.onCloseGenerator).nthCalledWith(3, 2);
  });
});
