import * as React from "react";

import { DetailedUser } from "aegis/models";
import { AlignContent, AlignItems, Display, FlexDirection, FlexWrap, Layout } from "twitch-core-ui";
import { UserPill } from "./user-pill";

export interface PublicProps {
  onCloseGenerator: (index: number) => (() => void);
  chatters?: DetailedUser[];
}

type Props = PublicProps;

export class MultiUserInput extends React.PureComponent<Props> {
  render() {
    const { chatters, onCloseGenerator } = this.props;

    const userPills =
      chatters &&
      chatters.map((user, index) => {
        return user && <UserPill key={`${user.id}-${index}`} user={user} onClickClose={onCloseGenerator(index)} />;
      });

    return (
      <Layout
        className={"chat-activity--form-input"}
        display={Display.Flex}
        flexDirection={FlexDirection.Row}
        flexWrap={FlexWrap.Wrap}
        alignItems={AlignItems.Start}
        alignContent={AlignContent.Start}
        fullWidth
      >
        {userPills}
      </Layout>
    );
  }
}
