import * as React from "react";

import { shallow } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { UserCard } from "aegis/features/user-card";
import { ToggleBalloonWrapper } from "aegis/functionality/components/toggle-balloon-wrapper";
import { MockDetailedUser } from "aegis/models/mocks";
import { CoreText, SVG } from "twitch-core-ui";
import { PublicProps, TestSelectors, UserPill } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setup = (overrides?: Partial<PublicProps>) => {
  const props: PublicProps = {
    onClickClose: jest.fn(),
    user: MockDetailedUser({ id: "user3", login: "userLogin3" }),
    ...overrides
  };

  return {
    props,
    wrapper: shallow(<UserPill {...props} />)
  };
};

describe("UserPill", () => {
  it("renders", () => {
    const { wrapper } = setup();

    expect(wrapper.find(SVG)).toHaveLength(1);
    expect(wrapper.find(ToggleBalloonWrapper)).toHaveLength(1);
    expect(wrapper.find(UserCard)).toHaveLength(1);
    expect(
      wrapper
        .find(CoreText)
        .childAt(0)
        .text()
    ).toBe("userLogin3");
  });

  it("calls onClickClose when click Close SVG", () => {
    const { props, wrapper } = setup();
    wrapper.find({ "data-test-selector": TestSelectors.Close }).simulate("click");
    expect(props.onClickClose).toHaveBeenCalled();
  });
});
