import { UserCard } from "aegis/features/user-card";
import { ToggleBalloonWrapper } from "aegis/functionality/components/toggle-balloon-wrapper";
import { DetailedUser } from "aegis/models";
import * as React from "react";
import {
  AlignItems,
  Background,
  Balloon,
  BorderRadius,
  Color,
  CoreText,
  Display,
  InjectLayout,
  Interactable,
  InteractableType,
  Layout,
  StyledLayout,
  SVG,
  SVGAsset
} from "twitch-core-ui";

export enum TestSelectors {
  UserLogin = "user-pill--user-login",
  Close = "user-pill--close"
}

export interface PublicProps {
  user: DetailedUser;
  onClickClose: () => void;
}

export class UserPill extends React.PureComponent<PublicProps> {
  render() {
    const { user, onClickClose } = this.props;

    return (
      <StyledLayout
        className={"chat-activity--user-block"}
        padding={{ x: 0.5, y: 0.5 }}
        margin={{ x: 1, y: 0.5 }}
        background={Background.Alt2}
        color={Color.Base}
        display={Display.InlineFlex}
        alignItems={AlignItems.Center}
        borderRadius={BorderRadius.Medium}
      >
        <ToggleBalloonWrapper>
          <Interactable
            data-track-click="chat-activity-user-pill-show-card"
            type={InteractableType.Alpha}
            borderRadius={BorderRadius.Small}
            data-test-selector={TestSelectors.UserLogin}
          >
            <Layout padding={{ x: 1 }}>
              <CoreText>{user.login}</CoreText>
            </Layout>
          </Interactable>
          <Balloon>
            <UserCard userID={user.id} />
          </Balloon>
        </ToggleBalloonWrapper>

        <InjectLayout fullHeight>
          <Interactable
            data-track-click="chat-activity-remove-user"
            type={InteractableType.Alpha}
            borderRadius={BorderRadius.Small}
            onClick={onClickClose}
            data-test-selector={TestSelectors.Close}
          >
            <SVG asset={SVGAsset.Close} />
          </Interactable>
        </InjectLayout>
      </StyledLayout>
    );
  }
}
