import * as React from "react";

import { Button, ButtonType, Color, CoreText, Display, InjectLayout, Layout, TextType } from "twitch-core-ui";
import { ChatActivityInfo } from "../models";
import { ChatActivityCard } from "./chat-activity-card";

export enum TestSelectors {
  ToggleAllButton = "chat-activity-results--toggle-all-button",
  NumberOfChannels = "chat-activity-results--number-of-channels",
  PlaceholderHint = "chat-activity-results--placeholder-hint"
}

export interface Props {
  users: string[] | null;
  activity: ChatActivityInfo[];
}

interface State {
  allOpen: boolean;
}

export class ChatActivityResults extends React.Component<Props, State> {
  public state: State = { allOpen: true };

  render() {
    const { users, activity } = this.props;
    const { allOpen } = this.state;
    const activityCards = activity.map((activityInfo: ChatActivityInfo) => (
      <ChatActivityCard key={activityInfo.channel.login} chatActivityInfo={activityInfo} isOpen={allOpen} />
    ));

    return (
      <Layout>
        <Layout padding={{ y: 1 }}>
          <CoreText color={Color.Alt2}>
            The results are limited to the 100 recently participated channels per user. (5 users searched, at most 500
            channels shown)
          </CoreText>
          <InjectLayout padding={{ y: 1 }}>
            <CoreText type={TextType.Span}>
              {"Showing "}
              <CoreText type={TextType.Span} bold data-test-selector={TestSelectors.NumberOfChannels}>
                {`${activityCards.length} ${activityCards.length === 1 ? "Channel" : "Channels"}`}
              </CoreText>
              {" above users have chatted in"}
            </CoreText>
          </InjectLayout>

          {activity && users ? (
            <Layout display={Display.Inline} padding={{ x: 2 }}>
              <Button
                data-track-click="chat-activity-result-toggle-all"
                type={ButtonType.Text}
                onClick={this.toggleAllOpen}
                data-test-selector={TestSelectors.ToggleAllButton}
              >
                {this.state.allOpen ? "Collapse All" : "Expand All"}
              </Button>
            </Layout>
          ) : (
            <CoreText color={Color.OverlayAlt} data-test-selector={TestSelectors.PlaceholderHint}>
              {"Please add usernames first from above."}
            </CoreText>
          )}
        </Layout>

        {activityCards}
      </Layout>
    );
  }

  toggleAllOpen = () => {
    this.setState(prevState => ({ allOpen: !prevState.allOpen }));
  };
}
