import * as React from "react";

import { shallow } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import "aegis/functionality/date-extensions.ts";
import { ChatActivityForm } from "./chat-activity-form";
import { ChatActivityResults } from "./chat-activity-results";
import { ChatActivityComponent, Props, PublicProps } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setup = (overrides?: Partial<PublicProps>) => {
  const combinedProps: Props = {
    users: null,
    data: {
      chatters: [],
      activity: []
    },
    ...overrides
  };

  return {
    props: combinedProps,
    wrapper: shallow(<ChatActivityComponent {...combinedProps} />)
  };
};

describe("ChatActivityComponent", () => {
  it("renders chat activity", () => {
    const { wrapper } = setup();

    expect(wrapper.find(ChatActivityForm)).toHaveLength(1);
    expect(wrapper.find(ChatActivityResults)).toHaveLength(1);
  });
});
