import * as React from "react";

import { Layout, StyledLayout } from "twitch-core-ui";
import { ChatActivityForm } from "./chat-activity-form";
import { ChatActivityResults } from "./chat-activity-results";
import { ChatActivityData } from "./models";

export interface PublicProps {
  users: string[] | null;
  errorMessage?: string;
  loading?: boolean;
  data?: ChatActivityData;
}

export type Props = PublicProps;

export class ChatActivityComponent extends React.Component<Props> {
  render() {
    const { data, users } = this.props;

    return (
      <Layout>
        <ChatActivityForm {...this.props} />
        <StyledLayout flexGrow={1} borderBottom />

        {this.props.children}

        {data && data.activity && <ChatActivityResults activity={data.activity} users={users} />}
      </Layout>
    );
  }
}
