import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockSuccessResponse } from "aegis/tests/apollo";
import { wrapWithGQLProvider } from "aegis/tests/graphql";
import { ChatActivityComponent } from "./component";
import { ChatActivity, ChatActivityQuery } from "./container";
import { FETCH_CHAT_ACTIVITY } from "./container";

Enzyme.configure({ adapter: new Adapter() });

const mockChatActivityData = {
  data: {
    chatActivity: {
      chatters: [],
      activity: []
    }
  }
};

const mockedChatActivity = mockSuccessResponse(FETCH_CHAT_ACTIVITY, {}, mockChatActivityData);

describe("ChatActivity", () => {
  it("does not render apollo query component when there is no input", () => {
    const wrapper = Enzyme.shallow(wrapWithGQLProvider(<ChatActivity users={[]} />, []).wrappedComponent);
    expect(
      wrapper
        .find(ChatActivity)
        .dive()
        .find(ChatActivityQuery)
    ).toHaveLength(0);
    expect(
      wrapper
        .find(ChatActivity)
        .dive()
        .find(ChatActivityComponent)
    ).toHaveLength(1);
  });

  it("has 'network-only' fetch policy to bypass apollo cache", () => {
    const wrapper = Enzyme.shallow(
      wrapWithGQLProvider(<ChatActivity users={["derper"]} />, [mockedChatActivity]).wrappedComponent
    );
    expect(
      wrapper
        .find(ChatActivity)
        .dive()
        .find(ChatActivityQuery)
        .prop("fetchPolicy")
    ).toBe("network-only");
  });

  it("puts the props into the gql variables", () => {
    const userProps: string[] = ["user1", "user2", "1234"];
    const wrapper = Enzyme.shallow(
      wrapWithGQLProvider(<ChatActivity users={userProps} />, [mockedChatActivity]).wrappedComponent
    );

    expect(wrapper.find(ChatActivity)).toHaveLength(1);
    expect(
      wrapper
        .find(ChatActivity)
        .dive()
        .find(ChatActivityQuery)
        .prop("variables")!.users
    ).toBe(userProps);
  });
});
