import * as React from "react";

import { TestSelectors as MessageTestSelectors } from "aegis/features/messages";
import { fakeMessage } from "aegis/features/messages/mocks";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { ChatLogsComponent, TestSelectors } from "./component";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

describe("ChatLogs", () => {
  it("renders with no messages", () => {
    const wrapper = Enzyme.shallow(<ChatLogsComponent chatEntries={[]} />);
    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.MessageLog })
        .dive()
        .find({ "data-test-selector": MessageTestSelectors.MessageRow }).length
    ).toBe(0);
  });

  it("renders with messages", () => {
    const wrapper = Enzyme.shallow(<ChatLogsComponent chatEntries={[fakeMessage, fakeMessage, fakeMessage]} />);
    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.MessageLog })
        .dive()
        .find({ "data-test-selector": MessageTestSelectors.MessageRow }).length
    ).toBe(3);
  });
});
