import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockChatroom } from "aegis/models/mocks";
import { waitSomeMs } from "aegis/tests/utils/wait-some-ms";
import { Chatroom, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Chatrooms", () => {
  it("renders the form with right value", () => {
    const room = MockChatroom();
    const wrapper = Enzyme.shallow(<Chatroom room={room} />);

    expect(wrapper.find({ "data-test-selector": TestSelectors.ID }).prop("children")).toBe(room.id);

    expect(wrapper.find({ "data-test-selector": TestSelectors.Name }).prop("children")).toBe(room.name);

    expect(wrapper.find({ "data-test-selector": TestSelectors.Topic }).prop("children")).toBe(room.topic);

    expect(wrapper.find({ "data-test-selector": TestSelectors.OwnerID }).prop("children")).toBe(room.ownerID);

    expect(wrapper.find({ "data-test-selector": TestSelectors.OwnerType }).prop("children")).toBe(room.ownerType);

    expect(wrapper.find({ "data-test-selector": TestSelectors.MinAllowRole }).prop("children")).toBe(
      room.minimumAllowedRole
    );

    expect(wrapper.find({ "data-test-selector": TestSelectors.Modes }).prop("children")).toBe(room.modes);

    expect(wrapper.find({ "data-test-selector": TestSelectors.UpdateButton }).length).toBe(0);
    expect(wrapper.find({ "data-test-selector": TestSelectors.EditButton }).length).toBe(1);

    expect(wrapper.find({ "data-test-selector": TestSelectors.DeleteButton }).prop("id")).toBe(room.id);
  });

  it("updates fields dynamically", async () => {
    const wrapper = Enzyme.shallow(<Chatroom room={MockChatroom()} />);
    const newName = "new name";
    const newTopic = "new topic";

    wrapper.find({ "data-test-selector": TestSelectors.EditButton }).simulate("click");
    await waitSomeMs();

    wrapper
      .find({ "data-test-selector": TestSelectors.Name })
      .simulate("change", { currentTarget: { value: newName } });

    wrapper
      .find({ "data-test-selector": TestSelectors.Topic })
      .simulate("change", { currentTarget: { value: newTopic } });

    expect(wrapper.find({ "data-test-selector": TestSelectors.UpdateButton }).prop("name")).toBe(newName);
    expect(wrapper.find({ "data-test-selector": TestSelectors.UpdateButton }).prop("topic")).toBe(newTopic);
  });
});
