import * as React from "react";

import { Button, ButtonType, Tooltip } from "twitch-core-ui";

export interface Props {
  error?: Error;
  deleted: boolean;
  loading: boolean;
  onClick: () => void;
}

export enum TestSelectors {
  Button = "delete-chatroom-button--button"
}

export const DeleteChatroomButtonComponent: React.SFC<Props> = ({ error, deleted, loading, onClick }) => {
  let tooltip: string;

  if (error) {
    tooltip = "An error occurred deleting the room. Please try again.";
  } else if (deleted) {
    tooltip = "This room has been deleted";
  } else {
    tooltip = "Click to delete this room";
  }

  return (
    <Tooltip label={tooltip}>
      <Button
        onClick={onClick}
        disabled={loading || deleted}
        type={ButtonType.Hollow}
        data-test-selector={TestSelectors.Button}
      >
        <i className="fa fa-trash" />
      </Button>
    </Tooltip>
  );
};
