import * as React from "react";

import { Button, ButtonType, Tooltip } from "twitch-core-ui";

export interface Props {
  error?: Error;
  deleted: boolean;
  loading: boolean;
  onClick: () => void;
}

export enum TestSelectors {
  Button = "delete-chatroom-message-button--button"
}

export const DeleteChatroomMessageButtonComponent: React.SFC<Props> = ({ error, deleted, loading, onClick }) => {
  let tooltip: string;

  if (error) {
    tooltip = "An error occurred deleting the message. Please try again.";
  } else if (deleted) {
    tooltip = "This message has been deleted";
  } else {
    tooltip = "Click to delete this message";
  }

  return (
    <Tooltip label={tooltip}>
      <Button
        data-track-click="delete-chatroom-message"
        onClick={onClick}
        disabled={loading || deleted}
        type={ButtonType.Hollow}
        data-test-selector={TestSelectors.Button}
      >
        <i className="fa fa-trash" />
      </Button>
    </Tooltip>
  );
};
