import * as React from "react";

import { Button, ButtonState, ButtonType } from "twitch-core-ui";

export interface Props {
  error?: Error;
  loading: boolean;
  success: boolean;
  onClick: () => void;
}

export const UpdateChatroomButtonComponent: React.SFC<Props> = ({ error, loading, success, onClick }) => {
  const buttonState = success ? ButtonState.Success : ButtonState.Default;
  const buttonText = error ? "Failed Try Again" : "Update";

  return (
    <Button
      data-track-click="update-chatroom"
      onClick={onClick}
      disabled={loading}
      state={loading ? ButtonState.Loading : buttonState}
      type={error ? ButtonType.Alert : ButtonType.Hollow}
    >
      {buttonText}
    </Button>
  );
};
