import * as React from "react";

import gql from "graphql-tag";
import { Mutation } from "react-apollo";

import { WithConfirmationModal } from "aegis/functionality/components/confirmation-modal";
import { Button, ButtonType } from "twitch-core-ui";

export interface PublicProps {
  id: string;
  onCompleted?: (results: DeleteVodCommentResponse) => void;
  onError?: (error: Error) => void;
  disabled?: boolean;
  type?: ButtonType;
  children?: React.ReactNode;
}

export type DeleteVodCommentResponse = {
  deleteVodComment: {
    success: boolean;
  };
};

export type DeleteVodCommentInput = {
  id: string;
};

export const DELETE_VOD_COMMENT = gql`
  mutation deleteVodComment($id: ID!) {
    deleteVodComment(input: { id: $id }) {
      success
    }
  }
`;

export enum TestSelectors {
  Button = "delete-vod-comment-button--button"
}

export class DeleteVodCommentMutation extends Mutation<DeleteVodCommentResponse, DeleteVodCommentInput> {}

export class DeleteVodCommentButton extends React.Component<PublicProps> {
  public render() {
    const { onError, onCompleted, disabled, children, type, id } = this.props;
    return (
      <DeleteVodCommentMutation mutation={DELETE_VOD_COMMENT} onError={onError} onCompleted={onCompleted}>
        {(deleteVodComment, { loading }) => {
          return (
            <WithConfirmationModal
              title="Delete VOD Comment"
              body="Are you sure you want to delete this VOD comment?"
              confirmLabelOverride="Delete"
              onConfirm={() => {
                deleteVodComment({ variables: { id } });
              }}
            >
              {confirm => {
                return (
                  <Button
                    data-track-click="delete-vod-comment-button"
                    onClick={confirm}
                    disabled={disabled !== undefined ? disabled : loading}
                    type={type}
                    children={children}
                    data-test-selector={TestSelectors.Button}
                  />
                );
              }}
            </WithConfirmationModal>
          );
        }}
      </DeleteVodCommentMutation>
    );
  }
}
