import * as React from "react";

import { CoreImage, Display, InjectLayout, Layout, Tooltip, VerticalAlign } from "twitch-core-ui";

export interface Props {
  id: string;
  emoteCode: string;
  version: 1 | 2 | 3;
  displayOverride?: Display;
}

export const Emote: React.StatelessComponent<Props> = ({ id, emoteCode, version, displayOverride }) => {
  const display: Display = displayOverride || Display.Inline;
  return (
    <Layout verticalAlign={VerticalAlign.Middle} display={display}>
      <Tooltip display={display} label={emoteCode}>
        <InjectLayout verticalAlign={VerticalAlign.Middle}>
          <CoreImage alt={emoteCode} src={`//static-cdn.jtvnw.net/emoticons/v1/${id}/${version}.0`} />
        </InjectLayout>
      </Tooltip>
    </Layout>
  );
};
